/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import com.mojang.blaze3d.platform.Window;
import mcinterface1201.InterfaceRender;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.mixin.client.CameraMixin;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InterfaceEventsEntityRendering {
    public static final Point3D cameraAdjustedPosition = new Point3D();
    public static final RotationMatrix cameraAdjustedOrientation = new RotationMatrix();
    public static boolean adjustedCamera;
    private static Player mcPlayer;
    private static int lastScreenWidth;
    private static int lastScreenHeight;

    @SubscribeEvent
    public static void onIVCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Camera camera = event.getCamera();
        if (camera.m_90592_() instanceof Player) {
            mcPlayer = (Player)camera.m_90592_();
            WrapperPlayer player = WrapperPlayer.getWrapperFor(mcPlayer);
            cameraAdjustedPosition.set(0.0, 0.0, 0.0);
            cameraAdjustedOrientation.setToZero();
            float partialTicks = (float)event.getPartialTick();
            adjustedCamera = false;
            if (CameraSystem.adjustCamera(player, cameraAdjustedPosition, cameraAdjustedOrientation, partialTicks)) {
                cameraAdjustedOrientation.convertToAngles();
                if (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.THIRD_PERSON_INVERTED) {
                    event.setRoll((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.z));
                    event.setPitch((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.x));
                    event.setYaw((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.y + 180.0));
                } else {
                    event.setRoll((float)InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.z);
                    event.setPitch((float)InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.x);
                    event.setYaw((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.y));
                }
                ((CameraMixin)camera).invoke_setPosition(InterfaceEventsEntityRendering.cameraAdjustedPosition.x, InterfaceEventsEntityRendering.cameraAdjustedPosition.y, InterfaceEventsEntityRendering.cameraAdjustedPosition.z);
                adjustedCamera = true;
            }
        }
    }

    @SubscribeEvent
    public static void onIVPreLayer(RenderGuiOverlayEvent.Pre event) {
        IWrapperPlayer player;
        AEntityB_Existing ridingEntity;
        if ((event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type() || event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) && CameraSystem.customCameraOverlay != null) {
            event.setCanceled(true);
            return;
        }
        if ((event.getOverlay() == VanillaGuiOverlay.HOTBAR.type() || event.getOverlay() == VanillaGuiOverlay.FOOD_LEVEL.type() || event.getOverlay() == VanillaGuiOverlay.PLAYER_HEALTH.type() || event.getOverlay() == VanillaGuiOverlay.ARMOR_LEVEL.type() || event.getOverlay() == VanillaGuiOverlay.EXPERIENCE_BAR.type()) && (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? (Boolean)ConfigSystem.client.renderingSettings.renderHUD_1P.value : (Boolean)ConfigSystem.client.renderingSettings.renderHUD_3P.value).booleanValue() && (ridingEntity = (player = InterfaceManager.clientInterface.getClientPlayer()).getEntityRiding()) instanceof PartSeat && ((PartSeat)ridingEntity).placementDefinition.isController) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onIVRenderOverlayChat(CustomizeGuiOverlayEvent.Chat event) {
        boolean updateGUIs;
        Window window = Minecraft.m_91087_().m_91268_();
        long displaySize = InterfaceManager.clientInterface.getPackedDisplaySize();
        int screenWidth = (int)(displaySize >> 32);
        int screenHeight = (int)displaySize;
        double[] xPos = new double[1];
        double[] yPos = new double[1];
        GLFW.glfwGetCursorPos((long)window.m_85439_(), (double[])xPos, (double[])yPos);
        int mouseX = (int)(xPos[0] * (double)screenWidth / (double)window.m_85443_());
        int mouseY = (int)(yPos[0] * (double)screenHeight / (double)window.m_85444_());
        float partialTicks = event.getPartialTick();
        boolean bl = updateGUIs = screenWidth != lastScreenWidth || screenHeight != lastScreenHeight;
        if (updateGUIs) {
            lastScreenWidth = screenWidth;
            lastScreenHeight = screenHeight;
        }
        InterfaceRender.renderGUI(event.getGuiGraphics(), mouseX, mouseY, screenWidth, screenHeight, partialTicks, updateGUIs);
    }

    @SubscribeEvent
    public static void onIVRenderHand(RenderHandEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.m_91087_().f_91074_.m_20148_());
        if (entity != null && entity.activeGun != null || CameraSystem.activeCamera != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onIVRenderArm(RenderArmEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.m_91087_().f_91074_.m_20148_());
        if (entity != null && entity.activeGun != null || CameraSystem.activeCamera != null) {
            event.setCanceled(true);
        }
    }
}

